<?php
class Registermodel extends CI_Model{
/*default functions*/
public function common_fetch($table,$where){
	$this->db->where($where);
	$this->db->order_by('id','desc');
	$query = $this->db->get($table);
	return $query->result_array();
}
public function common_fetch_alphabet($table,$where){
	$this->db->where($where);
	$this->db->order_by('name','asc');
	$query = $this->db->get($table);
	return $query->result_array();
}
public function common_fetch_asc($table,$where){
	$this->db->where($where);
	$this->db->order_by('id','asc');
	$query = $this->db->get($table);
	return $query->result_array();
}
public function common_fetch_rows($table,$where){
	$this->db->where($where); 
	$this->db->order_by('id','desc');
	$query = $this->db->get($table);
	return $query->num_rows();
}
public function common_insert($table,$data){
	$this->db->insert($table,$data);
	$id = $this->db->insert_id();
	return $id;
}
public function common_update($table,$data,$where){
	$this->db->where($where);
	$this->db->update($table,$data);
}
public function common_delete($table,$where){
	$this->db->where($where);
	$this->db->delete($table);
}
public function common_or_where($table,$where,$where2){
    $this->db->where($where);
    $this->db->group_start();
    $this->db->or_where($where2);
    $this->db->group_end();
    $this->db->order_by('id','desc');
	$query = $this->db->get($table);
	return $query->result_array();
    
}
/*default functions*/

/*user statistics*/
public function user_statistics($id){
    $this->db->select('ch.id as id,u.name as uname,e.name as ename,s.name as sname,sc.name as scname,ch.created_on as created_on')->from('call_history ch');
    $this->db->where('user_id',base64_decode($id));
    $this->db->join('users u','u.id=ch.user_id','left');
    $this->db->join('employees e','e.id=ch.emp_id','left');
    $this->db->join('services s','s.id=ch.cat_id','left');
    $this->db->join('sub_categories sc','sc.id=ch.sub_cat_id','left');
    $query = $this->db->get();
	return $query->result_array();
}
public function user_statistics_search($data,$id){
    $this->db->select('ch.id as id,u.name as uname,e.name as ename,s.name as sname,sc.name as scname,ch.created_on as created_on')->from('call_history ch');
    $this->db->where(['ch.user_id' => base64_decode($id),'ch.cat_id' => $data['search'],'ch.sub_cat_id' => $data['sub_cat_id']]);
    $this->db->join('users u','u.id=ch.user_id','left');
    $this->db->join('employees e','e.id=ch.emp_id','left');
    $this->db->join('services s','s.id=ch.cat_id','left');
    $this->db->join('sub_categories sc','sc.id=ch.sub_cat_id','left');
    $query = $this->db->get();
	return $query->result_array();
}
/*user statistics*/

/*user monthly revenue*/
public function get_revenue($month,$year){
    $this->db->select('SUM(mr.price) as total_amount')-> from('monthly_revenue mr');
    $this->db->where(['month' => $month,'year' => $year]);
    $query = $this->db->get();
    return $query->result_array();
    //echo $result->price;
}
public function monthly_revenue($month_id,$year){
    $this->db->select('mr.*,u.name as uname,m.name as mname')->from('monthly_revenue mr');
    $this->db->where(['month' => $month_id,'year' => $year]);
    $this->db->join('users u','u.id=mr.user_id','left');
    $this->db->join('months m','m.id=mr.month','left');
    $query = $this->db->get();
    return $query->result_array();
}
/*user monthly revenue*/

/*user calls*/
public function users_calls($user_id){
    $this->db->select('ch.*,u.name,s.name as l1_cat,sc.name as l2_cat,e.name as emp_name')->from('call_history ch');
    $this->db->where('ch.user_id',$user_id);
    $this->db->join('users u','u.id=ch.user_id','left');
    $this->db->join('services s','s.id=ch.cat_id','left');
    $this->db->join('sub_categories sc','sc.id=ch.sub_cat_id','left');
    $this->db->join('employees e','e.id=ch.emp_id','left');
    $this->db->order_by('id','desc');
    $query = $this->db->get();
    return $query->result_array();
}
/*user calls*/

/*cat calls*/
public function cat_calls($category_id){
    $this->db->select('ch.*,u.name,s.name as l1_cat,sc.name as l2_cat,e.name as emp_name')->from('call_history ch');
    $this->db->where('ch.cat_id',$category_id);
    $this->db->join('users u','u.id=ch.user_id','left');
    $this->db->join('services s','s.id=ch.cat_id','left');
    $this->db->join('sub_categories sc','sc.id=ch.sub_cat_id','left');
    $this->db->join('employees e','e.id=ch.emp_id','left');
    $this->db->order_by('id','desc');
    $query = $this->db->get();
    return $query->result_array();
}
/*cat calls*/

/*city monthly revenue*/
public function get_city_revenue($city_id,$year){
    $this->db->select('SUM(mr.price) as total_amount')-> from('monthly_revenue mr');
    $this->db->where(['year' => $year,'city_id' => $city_id]);
    $query = $this->db->get();
    return $query->result_array();
    //echo $result->price;
}
public function city_monthly_revenue($city_id){
    $this->db->select('mr.*,u.name as uname,m.name as mname,c.name as cname')->from('monthly_revenue mr');
    $this->db->where(['mr.year' => date('Y'),'mr.city_id' => $city_id]);
    $this->db->join('users u','u.id=mr.user_id','left');
    $this->db->join('months m','m.id=mr.month','left');
    $this->db->join('cities c','c.id=mr.city_id','left');
    $query = $this->db->get();
    return $query->result_array();
    //echo $result->price;
}
/*city monthly revenue*/

/*total revenue*/
public function total_revenue(){
    $this->db->select('mr.*,u.name as uname,m.name as mname,c.name as cname')->from('monthly_revenue mr');
    $this->db->where(['mr.year' => date('Y')]);
    $this->db->join('users u','u.id=mr.user_id','left');
    $this->db->join('months m','m.id=mr.month','left');
    $this->db->join('cities c','c.id=mr.city_id','left');
    $this->db->where('year',date('Y'));
    $query = $this->db->get();
    return $query->result_array();
    //echo $result->price;
}
public function get_total_revenue(){
    $this->db->select('SUM(mr.price) as total_amount')-> from('monthly_revenue mr');
    $this->db->where(['year' => date('Y')]);
    $query = $this->db->get();
    return $query->result_array();
    //echo $result->price;
}
/*total revenue*/

/*user calls*/
public function user_calls_below20_admin(){
    $this->db->select('call_history.*,COUNT(user_id) as count,u.name,s.name as l1_cat,sc.name as l2_cat,e.name as emp_name');
    $this->db->from('call_history');
    //$this->db->where('user_id', $user_ids);         // Filter by user_id
    $this->db->group_by('user_id');             // Group by user_id
    $this->db->having('count >=', 0);           // HAVING clause to filter count >= 0
    $this->db->having('count <=', 20);          // HAVING clause to filter count <= 20
    $this->db->join('users u','u.id=call_history.user_id','left');
    $this->db->join('services s','s.id=call_history.cat_id','left');
    $this->db->join('sub_categories sc','sc.id=call_history.sub_cat_id','left');
    $this->db->join('employees e','e.id=call_history.emp_id','left');
    $query = $this->db->get();
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return [];
    }
}

public function user_calls_below30_admin(){
    $this->db->select('call_history.*,COUNT(user_id) as count,u.name,s.name as l1_cat,sc.name as l2_cat,e.name as emp_name');
    $this->db->from('call_history');
    //$this->db->where('user_id', $user_ids);         // Filter by user_id
    $this->db->group_by('user_id');             // Group by user_id
    $this->db->having('count >=', 20);           // HAVING clause to filter count >= 0
    $this->db->having('count <=', 30);          // HAVING clause to filter count <= 20
    $this->db->join('users u','u.id=call_history.user_id','left');
    $this->db->join('services s','s.id=call_history.cat_id','left');
    $this->db->join('sub_categories sc','sc.id=call_history.sub_cat_id','left');
    $this->db->join('employees e','e.id=call_history.emp_id','left');
    $query = $this->db->get();
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return [];
    }
}

public function user_calls_below40_admin(){
    $this->db->select('call_history.*,COUNT(user_id) as count,u.name,s.name as l1_cat,sc.name as l2_cat,e.name as emp_name');
    $this->db->from('call_history');
    //$this->db->where('user_id', $user_ids);         // Filter by user_id
    $this->db->group_by('user_id');             // Group by user_id
    $this->db->having('count >=', 30);           // HAVING clause to filter count >= 0
    $this->db->having('count <=', 40);          // HAVING clause to filter count <= 20
    $this->db->join('users u','u.id=call_history.user_id','left');
    $this->db->join('services s','s.id=call_history.cat_id','left');
    $this->db->join('sub_categories sc','sc.id=call_history.sub_cat_id','left');
    $this->db->join('employees e','e.id=call_history.emp_id','left');
    $query = $this->db->get();
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return [];
    }
}

public function user_calls_above40_admin(){
    $this->db->select('call_history.*,COUNT(user_id) as count,u.name,s.name as l1_cat,sc.name as l2_cat,e.name as emp_name');
    $this->db->from('call_history');
    //$this->db->where('user_id', $user_ids);         // Filter by user_id
    $this->db->group_by('user_id');             // Group by user_id
    $this->db->having('count >', 40);           // HAVING clause to filter count >= 0
    //$this->db->having('count <=', 40);          // HAVING clause to filter count <= 20
    $this->db->join('users u','u.id=call_history.user_id','left');
    $this->db->join('services s','s.id=call_history.cat_id','left');
    $this->db->join('sub_categories sc','sc.id=call_history.sub_cat_id','left');
    $this->db->join('employees e','e.id=call_history.emp_id','left');
    $query = $this->db->get();
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return [];
    }
}

/*user calls*/

/*employee experience*/
public function emp_exp_below_3(){
    $this->db->select('AVG(rating) as avg_rating, emp_id,ratings_reviews.id,e.name as emp_name');
    $this->db->from('ratings_reviews');
    $this->db->having('avg_rating >=', 2);       // Minimum rating of 2
    $this->db->having('avg_rating <=', 3);       // Maximum rating of 3
    $this->db->group_by('emp_id');     // Group by employee to get avg per employee
    $this->db->join('employees e','e.id=ratings_reviews.emp_id','left');
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();   // Return the result array
    } else {
        return [];   // Return an empty array if no results
    }
}
public function emp_exp_below_4(){
    $this->db->select('AVG(rating) as avg_rating, emp_id,ratings_reviews.id,e.name as emp_name');
    $this->db->from('ratings_reviews');
    $this->db->having('avg_rating >=', 3);       // Minimum rating of 2
    $this->db->having('avg_rating <=', 4);       // Maximum rating of 3
    $this->db->group_by('emp_id');     // Group by employee to get avg per employee
    $this->db->join('employees e','e.id=ratings_reviews.emp_id','left');
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();   // Return the result array
    } else {
        return [];   // Return an empty array if no results
    }
}
public function emp_exp_above_4(){
    $this->db->select('AVG(rating) as avg_rating, emp_id,ratings_reviews.id,e.name as emp_name');
    $this->db->from('ratings_reviews');
    $this->db->having('avg_rating >', 4);       // Minimum rating of 2
    //$this->db->having('avg_rating <=', 4);       // Maximum rating of 3
    $this->db->group_by('emp_id');     // Group by employee to get avg per employee
    $this->db->join('employees e','e.id=ratings_reviews.emp_id','left');
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();   // Return the result array
    } else {
        return [];   // Return an empty array if no results
    }
}
/*employee experience*/


public function employees($page,$seg){
    $this->db->where(['cat_id!=' => ''/*,'sub_cat_id!=' => ''*/,'mobile!=' => '','name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
	$this->db->order_by('id','desc');
	$this->db->limit($page,$seg);
	$query = $this->db->get('employees');
	return $query->result_array();
}
public function incompleted_employees_rows(){
    $this->db->where('delete_status',1);
    $this->db->group_start();
    $this->db->or_where(['cat_id' => ''/*,'sub_cat_id' => ''*/,'mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
    $this->db->group_end();
    $this->db->order_by('id','asc');
	$query = $this->db->get('employees');
	return $query->num_rows();
    
}
public function incompleted_employees($page,$seg){
    $this->db->where('delete_status',1);
    $this->db->group_start();
    $this->db->or_where(['cat_id' => ''/*,'sub_cat_id' => ''*/,'mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
    $this->db->group_end();
    $this->db->order_by('id','asc');
    $this->db->limit($page,$seg);
	$query = $this->db->get('employees');
	return $query->result_array();
}
public function whatsapp_employees_rows(){
    $this->db->where(['delete_status' => 1,'emp_status' => 'whatsapp']);
    //$this->db->group_start();
    $this->db->where(['cat_id!=' => 0,'sub_cat_id!=' => 0/*,'sub_cat_id' => ''*/,'mobile!=' => '']);
    //$this->db->group_end();
    $this->db->group_start();
    $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
    $this->db->group_end();
    $this->db->order_by('id','asc');
	$query = $this->db->get('employees');
	return $query->num_rows();

    
//     $this->db->where(['delete_status' => 1,'emp_status' => 'whatsapp']);
//     $this->db->group_start();
//     $this->db->or_where(['cat_id' => ''/*,'sub_cat_id' => ''*/,'mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
//     $this->db->group_end();
//     $this->db->order_by('id','desc');
// 	$query = $this->db->get('employees');
// 	return $query->num_rows();
    
}
public function whatsapp_employees($page,$seg){
    $this->db->where(['delete_status' => 1,'emp_status' => 'whatsapp']);
    //$this->db->group_start();
    $this->db->where(['cat_id!=' => 0,'sub_cat_id!=' => 0/*,'sub_cat_id' => ''*/,'mobile!=' => '']);
    //$this->db->group_end();
    $this->db->group_start();
    $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
    $this->db->group_end();
    $this->db->order_by('id','asc');
    $this->db->limit($page,$seg);
	$query = $this->db->get('employees');
	return $query->result_array();
//     $this->db->where(['delete_status' => 1,'emp_status' => 'whatsapp']);
//     $this->db->group_start();
//     $this->db->or_where(['cat_id' => ''/*,'sub_cat_id' => ''*/,'mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
//     $this->db->group_end();
//     $this->db->order_by('id','desc');
//     $this->db->limit($page,$seg);
// 	$query = $this->db->get('employees');
// 	return $query->result_array();
}


public function whatsapp_employees_test_rows(){

    $this->db->where(['delete_status' => 1,'emp_status' => 'whatsapp']);
    //$this->db->group_start();
    $this->db->where(['cat_id' => 0/*,'sub_cat_id' => ''*/,'mobile!=' => '']);
    //$this->db->group_end();
    $this->db->group_start();
    $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
    $this->db->group_end();
    $this->db->order_by('id','desc');
	$query = $this->db->get('employees');
	return $query->num_rows();
    
}
public function whatsapp_employees_test($page,$seg){
    $this->db->where(['delete_status' => 1,'emp_status' => 'whatsapp']);
    $this->db->group_start();
    $this->db->or_where(['cat_id' => ''/*,'sub_cat_id' => ''*/,'mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
    $this->db->group_end();
    $this->db->order_by('id','desc');
    $this->db->limit($page,$seg);
	$query = $this->db->get('employees');
	return $query->result_array();
}



public function mised_call_employees_rows(){
    $this->db->where(['delete_status' => 1,'emp_status' => 'missed_call']);
    //$this->db->group_start();
    $this->db->where(['cat_id' => 0,'sub_cat_id' => 0/*,'sub_cat_id' => ''*/,'mobile!=' => '']);
    //$this->db->group_end();
    $this->db->group_start();
    $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
    $this->db->group_end();
    $this->db->order_by('id','asc');
	$query = $this->db->get('employees');
	return $query->num_rows();
    
//     $this->db->where(['delete_status' => 1,'emp_status' => 'missed_call']);
//     $this->db->group_start();
//     $this->db->or_where(['cat_id' => ''/*,'sub_cat_id' => ''*/,'mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
//     $this->db->group_end();
//     $this->db->order_by('id','desc');
//     $this->db->limit($page,$seg);
// 	$query = $this->db->get('employees');
// 	return $query->num_rows();
}
public function mised_call_employees($page,$seg){
    $this->db->where(['delete_status' => 1,'emp_status' => 'missed_call']);
    //$this->db->group_start();
    $this->db->where(['cat_id' => 0,'sub_cat_id' => 0/*,'sub_cat_id' => ''*/,'mobile!=' => '']);
    //$this->db->group_end();
    $this->db->group_start();
    $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
    $this->db->group_end();
    $this->db->order_by('id','asc');
    $this->db->limit($page,$seg);
	$query = $this->db->get('employees');
	return $query->result_array();
    
//     $this->db->where(['delete_status' => 1,'emp_status' => 'missed_call']);
//     $this->db->group_start();
//     $this->db->or_where(['cat_id' => ''/*,'sub_cat_id' => ''*/,'mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
//     $this->db->group_end();
//     $this->db->order_by('id','desc');
//     $this->db->limit($page,$seg);
// 	$query = $this->db->get('employees');
// 	return $query->result_array();
}
public function get_employees_search_rows($user_search,$uri){
    if($uri=='employees'){
        $this->db->where(['cat_id!=' => '','sub_cat_id!=' => '','mobile!=' => '','name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
    	$this->db->group_start();
    	$this->db->like('id',$user_search);
    	$this->db->or_like('name',$user_search);
    	$this->db->or_like('mobile',$user_search);
    	$this->db->or_like('profession',$user_search);
    	$this->db->or_like('exp',$user_search);
    	$this->db->or_like('engagement',$user_search);
    	$this->db->or_like('gender',$user_search);
    	$this->db->group_end();
    	$this->db->order_by('id','asc');
    	$query = $this->db->get('employees');
    	return $query->num_rows();
    }elseif($uri=='incompleted_employees'){
        $this->db->where('delete_status',1);
        $this->db->group_start();
        $this->db->or_where(['cat_id' => '','sub_cat_id' => '','mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();
    	$this->db->group_start();
    	$this->db->like('id',$user_search);
    	$this->db->or_like('name',$user_search);
    	$this->db->or_like('mobile',$user_search);
    	$this->db->or_like('profession',$user_search);
    	$this->db->or_like('exp',$user_search);
    	$this->db->or_like('engagement',$user_search);
    	$this->db->or_like('gender',$user_search);
    	$this->db->group_end();
    	$this->db->order_by('id','asc');
    	$query = $this->db->get('employees');
    	return $query->num_rows();
    }elseif($uri=='whatsapp_employees'){
        $this->db->where(['delete_status' => 1,'emp_status' => 'whatsapp']);
        /*$this->db->group_start();
        $this->db->or_where(['cat_id' => '','sub_cat_id' => '','mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();*/
        $this->db->where(['cat_id!=' => 0,'sub_cat_id!=' => 0/*,'sub_cat_id' => ''*/,'mobile!=' => '']);
        //$this->db->group_end();
        $this->db->group_start();
        $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();
        $this->db->group_start();
    	$this->db->like('id',$user_search);
    	$this->db->or_like('name',$user_search);
    	$this->db->or_like('mobile',$user_search);
    	$this->db->or_like('profession',$user_search);
    	$this->db->or_like('exp',$user_search);
    	$this->db->or_like('engagement',$user_search);
    	$this->db->or_like('gender',$user_search);
    	$this->db->group_end();
        $this->db->order_by('id','asc');
    	$query = $this->db->get('employees');
    	return $query->num_rows();
    }elseif($uri=='mised_call_employees'){
        $this->db->where(['delete_status' => 1,'emp_status' => 'missed_call']);
        /*$this->db->group_start();
        $this->db->or_where(['cat_id' => '','sub_cat_id' => '','mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();*/
        $this->db->where(['cat_id' => 0,'sub_cat_id' => 0/*,'sub_cat_id' => ''*/,'mobile!=' => '']);
        //$this->db->group_end();
        $this->db->group_start();
        $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();
        $this->db->order_by('id','asc');
        $this->db->group_start();
    	$this->db->like('id',$user_search);
    	$this->db->or_like('name',$user_search);
    	$this->db->or_like('mobile',$user_search);
    	$this->db->or_like('profession',$user_search);
    	$this->db->or_like('exp',$user_search);
    	$this->db->or_like('engagement',$user_search);
    	$this->db->or_like('gender',$user_search);
    	$this->db->group_end();
    	$query = $this->db->get('employees');
    	return $query->num_rows();
    }
}
public function search_employees($page,$seg,$user_search,$uri){
    if($uri=='employees'){
        $this->db->where(['cat_id!=' => '',/*'sub_cat_id!=' => '',*/'mobile!=' => '','name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
    	$this->db->group_start();
    	$this->db->like('id',$user_search);
    	$this->db->or_like('name',$user_search);
    	$this->db->or_like('mobile',$user_search);
    	$this->db->or_like('profession',$user_search);
    	$this->db->or_like('exp',$user_search);
    	$this->db->or_like('engagement',$user_search);
    	$this->db->or_like('gender',$user_search);
    	$this->db->group_end();
    	$this->db->order_by('id','asc');
    	$this->db->limit($page,$seg);
    	$query = $this->db->get('employees');
    	return $query->result_array();
    }elseif($uri=='employees_test'){
        $this->db->where(['cat_id!=' => '',/*'sub_cat_id!=' => '',*/'mobile!=' => '','name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
    	$this->db->group_start();
    	$this->db->like('id',$user_search);
    	$this->db->or_like('name',$user_search);
    	$this->db->or_like('mobile',$user_search);
    	$this->db->or_like('profession',$user_search);
    	$this->db->or_like('exp',$user_search);
    	$this->db->or_like('engagement',$user_search);
    	$this->db->or_like('gender',$user_search);
    	$this->db->group_end();
    	$this->db->order_by('id','asc');
    	$this->db->limit($page,$seg);
    	$query = $this->db->get('employees');
    	return $query->result_array();
    }elseif($uri=='employees_test'){
        $this->db->where(['cat_id!=' => '',/*'sub_cat_id!=' => '',*/'mobile!=' => '','name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
    	$this->db->group_start();
    	$this->db->like('id',$user_search);
    	$this->db->or_like('name',$user_search);
    	$this->db->or_like('mobile',$user_search);
    	$this->db->or_like('profession',$user_search);
    	$this->db->or_like('exp',$user_search);
    	$this->db->or_like('engagement',$user_search);
    	$this->db->or_like('gender',$user_search);
    	$this->db->group_end();
    	$this->db->order_by('id','asc');
    	$this->db->limit($page,$seg);
    	$query = $this->db->get('employees');
    	return $query->result_array();
    }elseif($uri=='incompleted_employees'){
        $this->db->where('delete_status',1);
        $this->db->group_start();
        $this->db->or_where(['cat_id' => ''/*,'sub_cat_id' => ''*/,'mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();
    	$this->db->group_start();
    	$this->db->like('id',$user_search);
    	$this->db->or_like('name',$user_search);
    	$this->db->or_like('mobile',$user_search);
    	$this->db->or_like('profession',$user_search);
    	$this->db->or_like('exp',$user_search);
    	$this->db->or_like('engagement',$user_search);
    	$this->db->or_like('gender',$user_search);
    	$this->db->group_end();
    	$this->db->order_by('id','asc');
    	$this->db->limit($page,$seg);
    	$query = $this->db->get('employees');
    	return $query->result_array();
    }elseif($uri=='whatsapp_employees'){
        $this->db->where(['delete_status' => 1,'emp_status' => 'whatsapp']);
        /*$this->db->group_start();
        $this->db->or_where(['cat_id' => ''/*,'sub_cat_id' => '','mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();*/
        $this->db->where(['cat_id!=' => 0,'sub_cat_id!=' => 0/*,'sub_cat_id' => ''*/,'mobile!=' => '']);
        //$this->db->group_end();
        $this->db->group_start();
        $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();
        $this->db->group_start(); 
    	$this->db->like('id',$user_search);
    	$this->db->or_like('name',$user_search);
    	$this->db->or_like('mobile',$user_search);
    	$this->db->or_like('profession',$user_search);
    	$this->db->or_like('exp',$user_search);
    	$this->db->or_like('engagement',$user_search);
    	$this->db->or_like('gender',$user_search);
    	$this->db->group_end();
        $this->db->order_by('id','asc');
        $this->db->limit($page,$seg);
    	$query = $this->db->get('employees');
    	return $query->result_array();
    }elseif($uri=='mised_call_employees'){
        $this->db->where(['delete_status' => 1,'emp_status' => 'missed_call']);
        /*$this->db->group_start();
        $this->db->or_where(['cat_id' => '','sub_cat_id' => '','mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();*/
        $this->db->where(['cat_id' => 0,'sub_cat_id' => 0/*,'sub_cat_id' => ''*/,'mobile!=' => '']);
        //$this->db->group_end();
        $this->db->group_start();
        $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();
        $this->db->order_by('id','asc');
        $this->db->group_start();
    	$this->db->like('id',$user_search);
    	$this->db->or_like('name',$user_search);
    	$this->db->or_like('mobile',$user_search);
    	$this->db->or_like('profession',$user_search);
    	$this->db->or_like('exp',$user_search);
    	$this->db->or_like('engagement',$user_search);
    	$this->db->or_like('gender',$user_search);
    	$this->db->group_end();
    	$this->db->limit($page,$seg);
    	$query = $this->db->get('employees');
    	return $query->result_array();
    }
}
public function get_employees_cat_search_rows($user_searchh,$uri){
    if($uri=='employees'){
        if(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&!empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id'],'sub_sub_cat_id' => $user_searchh['sub_sub_cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id']]);
        }
        $this->db->where(['mobile!=' => '','name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
    	$this->db->order_by('id','asc');
    	$query = $this->db->get('employees');
    	return $query->num_rows();
    }elseif($uri=='incompleted_employees'){
        if(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&!empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id'],'sub_sub_cat_id' => $user_searchh['sub_sub_cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id']]);
        }
        $this->db->where(['delete_status' => 1]);
        $this->db->group_start();
        $this->db->or_where(['mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();
    	$this->db->order_by('id','asc');
    	$query = $this->db->get('employees');
    	return $query->num_rows();
    }elseif($uri=='whatsapp_employees'){
        if(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&!empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id'],'sub_sub_cat_id' => $user_searchh['sub_sub_cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id']]);
        }
        $this->db->where(['delete_status' => 1,'emp_status' => 'whatsapp']);
        $this->db->where(['mobile!=' => '']);
        //$this->db->group_end();
        $this->db->group_start();
        $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();
        $this->db->order_by('id','asc');
    	$query = $this->db->get('employees');
    	return $query->num_rows();
    }elseif($uri=='mised_call_employees'){
        if(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&!empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id'],'sub_sub_cat_id' => $user_searchh['sub_sub_cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id']]);
        }
        $this->db->where(['delete_status' => 1,'emp_status' => 'missed_call']);
        $this->db->where(['mobile!=' => '']);
        //$this->db->group_end();
        $this->db->group_start();
        $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();
        $this->db->order_by('id','asc');
    	$query = $this->db->get('employees');
    	return $query->num_rows();
    }
}
public function search_employees_cat($page,$seg,$user_searchh,$uri){
    if($uri=='employees'){
        if(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&!empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id'],'sub_sub_cat_id' => $user_searchh['sub_sub_cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id']]);
        }
        $this->db->where(['mobile!=' => '','name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
    	$this->db->order_by('id','asc');
    	$this->db->limit($page,$seg);
    	$query = $this->db->get('employees');
    	return $query->result_array();
    }elseif($uri=='incompleted_employees'){
        if(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&!empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id'],'sub_sub_cat_id' => $user_searchh['sub_sub_cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id']]);
        }
        $this->db->where(['delete_status'=>1]);
        $this->db->group_start();
        $this->db->or_where(['mobile' => '','name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();
    	$this->db->order_by('id','asc');
    	$this->db->limit($page,$seg);
    	$query = $this->db->get('employees');
    	return $query->result_array();
    }elseif($uri=='whatsapp_employees'){
        if(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&!empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id'],'sub_sub_cat_id' => $user_searchh['sub_sub_cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id']]);
        }
        $this->db->where(['delete_status' => 1,'emp_status' => 'whatsapp']);
        $this->db->where(['mobile!=' => '']);
        //$this->db->group_end();
        $this->db->group_start();
        $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();
        $this->db->order_by('id','asc');
        $this->db->limit($page,$seg);
    	$query = $this->db->get('employees');
    	return $query->result_array();
    }elseif($uri=='mised_call_employees'){
        if(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&!empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id'],'sub_sub_cat_id' => $user_searchh['sub_sub_cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id']]);
        }elseif(!empty($user_searchh['cat_id'])&&!empty($user_searchh['sub_cat_id'])&&empty($user_searchh['sub_sub_cat_id'])){
            $this->db->where(['cat_id' => $user_searchh['cat_id'],'sub_cat_id' => $user_searchh['sub_cat_id']]);
        }
        $this->db->where(['delete_status' => 1,'emp_status' => 'missed_call']);
        $this->db->where(['mobile!=' => '']);
        //$this->db->group_end();
        $this->db->group_start();
        $this->db->or_where(['name' => '','profession' => '','exp' => '','engagement' => '','languages' => '','location' => '','gender' => '']);
        $this->db->group_end();
        $this->db->order_by('id','asc');
    	$this->db->limit($page,$seg);
    	$query = $this->db->get('employees');
    	return $query->result_array();
    }
}
public function employees_data($id){
    $this->db->select('c.name as ser_name,sc.name as sub_name,ssc.name as sub_sub_name,ci.name as loc_name')->from('employees e');
    $this->db->where('e.id',$id);
    $this->db->join('services c','c.id=e.cat_id','left');
    $this->db->join('sub_categories sc','sc.id=e.sub_cat_id','left');
    $this->db->join('sub_sub_categories ssc','ssc.id=e.sub_sub_cat_id','left');
    $this->db->join('cities ci','ci.id=e.location','left');
    $query = $this->db->get();
	return $query->result_array();
}

public function get_employee_languages($emp_id) {
        /*$this->db->select('GROUP_CONCAT(languages.name ORDER BY languages.name ASC SEPARATOR ", ") as languages');
        $this->db->where('employees.id',$emp_id);
        $this->db->from('employees');
        //$this->db->join('employee_languages', 'employee_languages.employee_id = employees.id', 'left');
        $this->db->join('languages', 'where_in(languages.id = employees.languages)', 'left');
        //$this->db->group_by('employees.id');
        $query = $this->db->get();
        return $query->result();*/
        
        $query = $this->db->query("
            SELECT e.id, e.name, e.languages, 
                   GROUP_CONCAT(l.name ORDER BY l.name ASC SEPARATOR ', ') as languages
            FROM employees e
            LEFT JOIN languages l ON FIND_IN_SET(l.id, e.languages)
            WHERE e.id = $emp_id
            GROUP BY e.id, e.name, e.languages
        ", array($emp_id));

        return $query->row();
        
    }

public function get_preffered_cities($emp_id) {
        /*$this->db->select('GROUP_CONCAT(languages.name ORDER BY languages.name ASC SEPARATOR ", ") as languages');
        $this->db->where('employees.id',$emp_id);
        $this->db->from('employees');
        //$this->db->join('employee_languages', 'employee_languages.employee_id = employees.id', 'left');
        $this->db->join('languages', 'where_in(languages.id = employees.languages)', 'left');
        //$this->db->group_by('employees.id');
        $query = $this->db->get();
        return $query->result();*/
        
        $query = $this->db->query("
            SELECT e.id, e.name, e.preferred_city, 
                   GROUP_CONCAT(c.name ORDER BY c.name ASC SEPARATOR ', ') as preferred_city
            FROM employees e
            LEFT JOIN cities c ON FIND_IN_SET(c.id, e.preferred_city)
            WHERE e.id = $emp_id
            GROUP BY e.id, e.name, e.preferred_city
        ", array($emp_id));

        return $query->row();
}


/*graph functions */
public function active_employees($page,$seg){
    $this->db->where(['cat_id!=' => ''/*,'sub_cat_id!=' => ''*/,'mobile!=' => '','name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','status' => 1,'delete_status' => 1]);
	$this->db->order_by('id','desc');
	$this->db->limit($page,$seg);
	$query = $this->db->get('employees');
	return $query->result_array();
}
public function inactive_employees($page,$seg){
    $this->db->where(['cat_id!=' => ''/*,'sub_cat_id!=' => ''*/,'mobile!=' => '','name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','status' => 0,'delete_status' => 1]);
	$this->db->order_by('id','desc');
	$this->db->limit($page,$seg);
	$query = $this->db->get('employees');
	return $query->result_array();
}
public function category_employees($cat_id,$page,$seg){
    $this->db->where(['cat_id' => base64_decode($cat_id)/*,'sub_cat_id!=' => ''*/,'mobile!=' => '','name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
	$this->db->order_by('id','desc');
	$this->db->limit($page,$seg);
	$query = $this->db->get('employees');
	return $query->result_array();
}
public function sub_category_employees($sub_cat_id,$page,$seg){
    $this->db->where(['sub_cat_id' => base64_decode($sub_cat_id),'mobile!=' => '','name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
	$this->db->order_by('id','desc');
	$this->db->limit($page,$seg);
	$query = $this->db->get('employees');
	return $query->result_array();
}
public function nativity_employees($nativity,$page,$seg){
    $this->db->where(['nativity' => base64_decode($nativity),'mobile!=' => '','name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
	$this->db->order_by('id','desc');
	$this->db->limit($page,$seg);
	$query = $this->db->get('employees');
	return $query->result_array();
}
/*graph functions*/

/*sub sub categories*/
public function sub_sub_category_employees($id,$page,$seg){
    $this->db->where(['sub_sub_cat_id' => base64_decode($id),'delete_status' => 1]);
	$this->db->order_by('id','desc');
	$this->db->limit($page,$seg);
	$query = $this->db->get('employees');
	return $query->result_array();
}
/*sub sub categories*/

/*business_types*/
public function all_ajax_business_types($postData){
    $response = array();

    ## Read value
    $draw = $postData['draw'];
    $start = $postData['start'];
    $rowPerPage = $postData['length']; // Rows display per page
    $columnIndex = $postData['order'][0]['column']; // Column index
    $columnName = $postData['columns'][$columnIndex]['data']; // Column name
    $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
    $searchValue = $postData['search']['value']; // Search value

    ## Search
    $searchQuery = "";
    if($searchValue != ''){
        $searchQuery = " (business_types.name like '%".$searchValue."%') ";
    }

    ## Total number of records without filtering
    $this->db->select('count(*) as allcount');
    $this->db->from('business_types');
    $this->db->where('delete_status',1);
    $records = $this->db->get()->result();
    $totalRecords = $records[0]->allcount;

    ## Total number of records with filtering
    $this->db->select('count(*) as allcount');
    $this->db->from('business_types');
    if($searchValue != ''){
        $this->db->where($searchQuery);
    }
    $this->db->where('business_types.delete_status',1);
    $records = $this->db->get()->result();
    $totalRecordwithFilter = $records[0]->allcount;

    ## Fetch records
    $this->db->select('business_types.*');
    $this->db->from('business_types');
    if($searchValue != ''){
        $this->db->where($searchQuery);
    }
    $this->db->where('business_types.delete_status',1);
    $this->db->order_by($columnName, $columnSortOrder);
    $this->db->limit($rowPerPage, $start);
    $records = $this->db->get()->result();

    $data = array();

    foreach($records as $record ){
        $data[] = array(
            "id"                    =>  $record->id,
            "name"                  =>  $record->name,
            "status"                =>  $record->status,
            "created_on"            =>  $record->created_on,
            "modified_on"           =>  $record->modified_on
        );
    }

    ## Response
    $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data
    );

    return $response;
}
/*business_types*/

/*job_postings*/
public function all_job_postings($postData) {
    $response = array();

    ## Read value
    $draw = $postData['draw'];
    $start = $postData['start'];
    $rowPerPage = $postData['length'];
    $columnIndex = $postData['order'][0]['column'];
    $columnName = $postData['columns'][$columnIndex]['data'];
    $columnSortOrder = $postData['order'][0]['dir'];
    $searchValue = $postData['search']['value'];

    ## Search
    $searchQuery = "";
    if ($searchValue != '') {
        $searchQuery = " (job_postings.id like '%" . $searchValue . "%' 
                        or users.name like '%" . $searchValue . "%' 
                        or users.business_name like '%" . $searchValue . "%' 
                        or services.name like '%" . $searchValue . "%' 
                        or sub_categories.name like '%" . $searchValue . "%') ";
    }

    ## Total records without filtering
    $this->db->select('count(*) as allcount');
    $this->db->from('job_postings');
    $records = $this->db->get()->result();
    $totalRecords = $records[0]->allcount;

    ## Total records with filtering
    $this->db->select('count(*) as allcount');
    $this->db->from('job_postings');
    $this->db->join('users', 'users.id = job_postings.user_id', 'left');
    $this->db->join('services', 'services.id = job_postings.cat_id', 'left');
    $this->db->join('sub_categories', 'sub_categories.id = job_postings.sub_cat_id', 'left');
    if ($searchQuery != '') {
        $this->db->where($searchQuery);
    }
    $records = $this->db->get()->result();
    $totalRecordwithFilter = $records[0]->allcount;

    ## Fetch records with matched_profiles_count subquery
    $this->db->select('
    job_postings.*,
    users.name,
    users.business_name,
    users.image,
    services.name as cat_name,
    sub_categories.name as sub_cat_name,
    IFNULL(sub_sub_categories.name, "") as sub_sub_cat_name,
    nativity.name as nativity_name,
    COUNT(DISTINCT job_applicants.id) as applicant_count,
    (
        SELECT GROUP_CONCAT(name SEPARATOR ", ")
        FROM languages
        WHERE FIND_IN_SET(id, job_postings.languages)
    ) as languages,
    (
        SELECT GROUP_CONCAT(name SEPARATOR ", ")
        FROM cities
        WHERE FIND_IN_SET(id, job_postings.preferred_city)
    ) as preferred_city,
    (
        SELECT COUNT(*) 
        FROM employees 
        WHERE 
            employees.cat_id = job_postings.cat_id 
            AND employees.sub_cat_id = job_postings.sub_cat_id 
            AND employees.sub_sub_cat_id = job_postings.sub_sub_cat_id 
            AND employees.exp = job_postings.exp 
            AND employees.engagement = job_postings.engagement 
            AND employees.gender = job_postings.gender 
            AND ( 
                employees.languages IS NULL 
                OR EXISTS (
                    SELECT 1 
                    FROM ( 
                        SELECT id 
                        FROM languages 
                        WHERE FIND_IN_SET(id, job_postings.languages) 
                    ) AS langs 
                    WHERE FIND_IN_SET(langs.id, employees.languages)
                ) 
            )
            AND (
                
                (
                    (job_postings.job_show_status = 1 AND employees.current_city = job_postings.current_city)
                )
    
                
                OR job_postings.job_show_status = 2
    
               
                OR (
                    job_postings.job_show_status = 3 
                    AND (
                        FIND_IN_SET((SELECT id FROM cities WHERE name = employees.current_city LIMIT 1), job_postings.preferred_city) 
                        OR FIND_IN_SET(employees.preferred_city, job_postings.preferred_city)
                    )
                )
            )
    ) AS matched_profiles_count
');

    $this->db->from('job_postings');
    $this->db->join('users', 'users.id = job_postings.user_id', 'left');
    $this->db->join('services', 'services.id = job_postings.cat_id', 'left');
    $this->db->join('sub_categories', 'sub_categories.id = job_postings.sub_cat_id', 'left');
    $this->db->join('sub_sub_categories', 'sub_sub_categories.id = job_postings.sub_sub_cat_id', 'left');
    $this->db->join('job_applicants', 'job_applicants.job_id = job_postings.id', 'left');
    $this->db->join('nativity', 'nativity.id = job_postings.nativity', 'left');
    if ($searchQuery != '') {
        $this->db->where($searchQuery);
    }
    $this->db->group_by('job_postings.id');
    $this->db->order_by($columnName, $columnSortOrder);
    $this->db->limit($rowPerPage, $start);
    $records = $this->db->get()->result();

    $data = array();
    foreach ($records as $record) {
        if (empty($record->sub_sub_cat_name)) {
            $record->sub_sub_cat_name = 'N/A';
        }
        if (empty($record->preferred_city)) {
            $record->preferred_city = 'N/A';
        }

        if ($record->job_show_status == 1) {
            $record->job_show_status = 'Current City';
        } elseif ($record->job_show_status == 2) {
            $record->job_show_status = 'Any City';
        } elseif ($record->job_show_status == 3) {
            $record->job_show_status = 'Preferred City';
        }

        $data[] = array(
            "id"                    => $record->id,
            "name"                  => $record->name,
            "business_name"         => $record->business_name,
            "image"                 => $record->image,
            "cat_name"              => $record->cat_name,
            "sub_cat_name"          => $record->sub_cat_name,
            "sub_sub_cat_name"      => $record->sub_sub_cat_name,
            "exp"                   => $record->exp,
            "engagement"            => $record->engagement,
            "languages"             => $record->languages,
            "job_show_status"       => $record->job_show_status,
            "preferred_city"        => $record->preferred_city,
            "nativity_name"         => $record->nativity_name,
            "gender"                => $record->gender,
            "current_city"          => $record->current_city,
            "current_state"         => $record->current_state,
            "lat"                   => $record->lat,
            "lon"                   => $record->lon,
            "applicant_count"       => $record->applicant_count,
            "matched_profiles_count"=> $record->matched_profiles_count,
            "created_on"            => $record->created_on,
        );
    }

    ## Response
    $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data
    );

    return $response;
}

public function all_job_applied($job_id,$postData) {
    $response = array();
    $job_id   = base64_decode($job_id);
    ## Read value
    $draw = $postData['draw'];
    $start = $postData['start'];
    $rowPerPage = $postData['length'];
    $columnIndex = $postData['order'][0]['column'];
    $columnName = $postData['columns'][$columnIndex]['data'];
    $columnSortOrder = $postData['order'][0]['dir'];
    $searchValue = $postData['search']['value'];

    ## Search
    $searchQuery = "";
    if ($searchValue != '') {
        $searchQuery = " (job_applicants.id like '%" . $searchValue . "%' 
                        or employees.name like '%" . $searchValue . "%' 
                        or services.name like '%" . $searchValue . "%' 
                        or sub_categories.name like '%" . $searchValue . "%') ";
    }

    ## Total records without filtering
    $this->db->select('count(*) as allcount');
    $this->db->from('job_applicants');
    $this->db->where("job_applicants.job_id = $job_id");
    $records = $this->db->get()->result();
    $totalRecords = $records[0]->allcount;

    ## Total records with filtering
    $this->db->select('count(*) as allcount');
    $this->db->from('job_applicants');
    $this->db->join('employees', 'employees.id = job_applicants.emp_id', 'left');
    $this->db->join('services', 'services.id = job_applicants.cat_id', 'left');
    $this->db->join('sub_categories', 'sub_categories.id = job_applicants.sub_cat_id', 'left');
    $this->db->where("job_applicants.job_id = $job_id");
    if ($searchQuery != '') {
        $this->db->where($searchQuery);
    }
    $records = $this->db->get()->result();
    $totalRecordwithFilter = $records[0]->allcount;

    ## Fetch records with matched_profiles_count subquery
    $this->db->select('
        job_applicants.*,
        employees.name,
        services.name as cat_name,
        sub_categories.name as sub_cat_name,
        IFNULL(sub_sub_categories.name, "") as sub_sub_cat_name,
        nativity.name as nativity_name,
        (
            SELECT GROUP_CONCAT(name SEPARATOR ", ")
            FROM languages
            WHERE FIND_IN_SET(id, job_applicants.languages)
        ) as languages
    ');
    $this->db->from('job_applicants');
    $this->db->join('employees', 'employees.id = job_applicants.emp_id', 'left');
    $this->db->join('services', 'services.id = job_applicants.cat_id', 'left');
    $this->db->join('sub_categories', 'sub_categories.id = job_applicants.sub_cat_id', 'left');
    $this->db->join('sub_sub_categories', 'sub_sub_categories.id = job_applicants.sub_sub_cat_id', 'left');
    $this->db->join('nativity', 'nativity.id = employees.nativity', 'left');
    $this->db->where("job_applicants.job_id = $job_id");
    if ($searchQuery != '') {
        $this->db->where($searchQuery);
    }
    $this->db->group_by('job_applicants.id');
    $this->db->order_by($columnName, $columnSortOrder);
    $this->db->limit($rowPerPage, $start);
    $records = $this->db->get()->result();

    $data = array();
    foreach ($records as $record) {
        if (empty($record->sub_sub_cat_name)) {
            $record->sub_sub_cat_name = 'N/A';
        }
        
        $data[] = array(
            "id"                    => $record->id,
            "name"                  => $record->name,
            "cat_name"              => $record->cat_name,
            "sub_cat_name"          => $record->sub_cat_name,
            "sub_sub_cat_name"      => $record->sub_sub_cat_name,
            "exp"                   => $record->exp,
            "engagement"            => $record->engagement,
            "languages"             => $record->languages,
            "applied_on"            => $record->applied_on,
            "status"                => $record->status,
            "created_on"            => $record->created_on,
        );
    }

    ## Response
    $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data
    );

    return $response;
}

public function all_job_matched($job_id, $postData) {
    $response = array();
    $job_id   = base64_decode($job_id);

    // DataTables vars
    $draw = $postData['draw'];
    $start = $postData['start'];
    $rowPerPage = $postData['length'];
    $columnIndex = $postData['order'][0]['column'];
    $columnName = $postData['columns'][$columnIndex]['data'];
    $columnSortOrder = $postData['order'][0]['dir'];
    $searchValue = $postData['search']['value'];

    // Get job data
    $job = $this->db->get_where('job_postings', ['id' => $job_id])->row_array();
    if (!$job) {
        return [
            "draw" => intval($draw),
            "iTotalRecords" => 0,
            "iTotalDisplayRecords" => 0,
            "aaData" => []
        ];
    }

    // Get city ID of the job's current city
    $city_id = $this->db->select('id')
                        ->from('cities')
                        ->where('name', $job['current_city'])
                        ->get()
                        ->row('id');

    // Search
    $searchQuery = "";
    if ($searchValue != '') {
        $searchQuery = " (employees.name LIKE '%$searchValue%' 
                        OR employees.mobile LIKE '%$searchValue%' 
                        OR employees.profession LIKE '%$searchValue%'
                        OR job_applicants.applied_on LIKE '%$searchValue%') ";
    }

    // Apply common matching filters
    $common_filters = [
        'employees.cat_id'         => $job['cat_id'],
        'employees.sub_cat_id'     => $job['sub_cat_id'],
        'employees.sub_sub_cat_id' => $job['sub_sub_cat_id'],
        'employees.exp'            => $job['exp'],
        'employees.engagement'     => $job['engagement'],
        'employees.gender'         => $job['gender'],
        'employees.availability'   => 1,
        'employees.status'         => 1,
        'employees.delete_status'  => 1
    ];

    // Total Records (without filter)
    $this->db->from('employees');
    $this->db->where($common_filters);
    $this->db->where("employees.name !=", "");
    $this->db->where("employees.profession !=", "");
    $this->db->where("employees.mobile !=", "");
    $this->db->where("employees.location !=", "");
    $this->db->where("employees.languages !=", "");
    $this->db->where("employees.exp !=", "");

    // Add job visibility logic
    $this->db->group_start();
        $this->db->group_start();
            $this->db->where('employees.current_city', $job['current_city']);
            $this->db->where('employees.emp_show_status', 1);
        $this->db->group_end();
        $this->db->or_group_start();
            $this->db->where('employees.emp_show_status', 3);
            $this->db->where("FIND_IN_SET('$city_id', employees.preferred_city) >", 0, false);
        $this->db->group_end();
        $this->db->or_group_start();
            $this->db->where('employees.emp_show_status', 2);
        $this->db->group_end();
    $this->db->group_end();

    $totalRecords = $this->db->count_all_results();

    // Total Records (with search)
    $this->db->from('employees');
    $this->db->where($common_filters);
    $this->db->where("employees.name !=", "");
    $this->db->where("employees.profession !=", "");
    $this->db->where("employees.mobile !=", "");
    $this->db->where("employees.location !=", "");
    $this->db->where("employees.languages !=", "");
    $this->db->where("employees.exp !=", "");

    if (!empty($job['languages'])) {
        $job_languages = explode(',', $job['languages']);
        $this->db->group_start();
        foreach ($job_languages as $lang_id) {
            $this->db->or_where("FIND_IN_SET($lang_id, employees.languages) >", 0, false);
        }
        $this->db->group_end();
    }

    if ($searchQuery != '') {
        $this->db->where($searchQuery);
    }

    // Job visibility logic again for filtered count
    $this->db->group_start();
        $this->db->group_start();
            $this->db->where('employees.current_city', $job['current_city']);
            $this->db->where('employees.emp_show_status', 1);
        $this->db->group_end();
        $this->db->or_group_start();
            $this->db->where('employees.emp_show_status', 3);
            $this->db->where("FIND_IN_SET('$city_id', employees.preferred_city) >", 0, false);
        $this->db->group_end();
        $this->db->or_group_start();
            $this->db->where('employees.emp_show_status', 2);
        $this->db->group_end();
    $this->db->group_end();

    $totalRecordwithFilter = $this->db->count_all_results();

    // Main query
    $this->db->select('
        employees.*,
        nativity.name as nativity_name,
        services.name as cat_name,
        sub_categories.name as sub_cat_name,
        IFNULL(sub_sub_categories.name, "") as sub_sub_cat_name,
        IFNULL(job_applicants.applied_on, "") as applied_on,
        (
            SELECT GROUP_CONCAT(name SEPARATOR ", ")
            FROM languages
            WHERE FIND_IN_SET(id, employees.languages)
        ) as languages
    ');
    $this->db->from('employees');
    $this->db->join('nativity', 'nativity.id = employees.nativity', 'left');
    $this->db->join('services', 'services.id = employees.cat_id', 'left');
    $this->db->join('sub_categories', 'sub_categories.id = employees.sub_cat_id', 'left');
    $this->db->join('sub_sub_categories', 'sub_sub_categories.id = employees.sub_sub_cat_id', 'left');
    $this->db->join('job_applicants', 'job_applicants.emp_id = employees.id', 'left');
    $this->db->where($common_filters);
    $this->db->where("employees.name !=", "");
    $this->db->where("employees.profession !=", "");
    $this->db->where("employees.mobile !=", "");
    $this->db->where("employees.location !=", "");
    $this->db->where("employees.languages !=", "");
    $this->db->where("employees.exp !=", "");

    if (!empty($job['languages'])) {
        $this->db->group_start();
        foreach ($job_languages as $lang_id) {
            $this->db->or_where("FIND_IN_SET($lang_id, employees.languages) >", 0, false);
        }
        $this->db->group_end();
    }

    if ($searchQuery != '') {
        $this->db->where($searchQuery);
    }

    // Visibility logic for main fetch
    $this->db->group_start();
        $this->db->group_start();
            $this->db->where('employees.current_city', $job['current_city']);
            $this->db->where('employees.emp_show_status', 1);
        $this->db->group_end();
        $this->db->or_group_start();
            $this->db->where('employees.emp_show_status', 3);
            $this->db->where("FIND_IN_SET('$city_id', employees.preferred_city) >", 0, false);
        $this->db->group_end();
        $this->db->or_group_start();
            $this->db->where('employees.emp_show_status', 2);
        $this->db->group_end();
    $this->db->group_end();

    $this->db->group_by('employees.id');
    $this->db->order_by($columnName, $columnSortOrder);
    $this->db->limit($rowPerPage, $start);
    $records = $this->db->get()->result();

    // Build response data
    $data = array();
    foreach ($records as $record) {
        if(empty($record->sub_sub_cat_name)){
            $record->sub_sub_cat_name = 'N/A';
        }
        if(empty($record->applied_on)){
            $record->applied_on = 'Not Applied';
        }
        $data[] = array(
            "id"              => $record->id,
            "name"            => $record->name,
            "mobile"          => $record->mobile,
            "cat_name"              => $record->cat_name,
            "sub_cat_name"          => $record->sub_cat_name,
            "sub_sub_cat_name"      => $record->sub_sub_cat_name,
            "mobile"          => $record->mobile,
            "profession"      => $record->profession,
            "exp"             => $record->exp,
            "engagement"      => $record->engagement,
            "languages"       => $record->languages,
            "nativity_name"   => $record->nativity_name,
            "location"        => $record->location,
            "applied_on"      => $record->applied_on,
            "job_call_lift_status"  => $record->job_call_lift_status,
            "created_on"      => $record->created_on
        );
    }

    return array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data
    );
}


/*job_postings*/


}
?>