<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Ws_model extends CI_Model{

/*default functions*/
public function common_fetch($table,$where){
	$this->db->where($where);
	$this->db->order_by('id','desc');
	$query = $this->db->get($table); 
	return $query->result_array();
}
public function common_fetch_limit($table,$where,$limit){
	$this->db->where($where);
	$this->db->limit($limit);
	$this->db->order_by('id','desc');
	$query = $this->db->get($table); 
	return $query->result_array();
}
public function common_fetch_asc($table,$where){
	$this->db->where($where);
	$this->db->order_by('id','asc');
	$query = $this->db->get($table);  
	return $query->result_array();
}
public function common_fetch_alph($table,$where){
	$this->db->where($where);
	$this->db->order_by('name','asc');
	$query = $this->db->get($table); 
	return $query->result_array();
}
public function common_insert($table,$data){	
	$this->db->insert($table,$data);
	$id = $this->db->insert_id();
	return $id;
}
public function common_update($table,$data,$where){
	$this->db->where($where);
	$this->db->update($table,$data);
}
public function common_delete($table,$where){
	$this->db->where($where);
	$this->db->delete($table);
}
public function common_fetch_rows($table,$where){
	$this->db->where($where);	
	$query = $this->db->get($table);
	return $query->num_rows();
}
public function common_search($table,$search,$where){
	$this->db->where($where);
	$this->db->like('name',$search);
	$this->db->order_by('id','desc');
	$query = $this->db->get($table); 
	return $query->result_array();
}
/*default functions*/

/*main data*/
// public function filter_search($data){
//   //$i=0;
//       $arr1 = explode(',',$data['gender']);
//       $arr2 = explode(',',$data['location']);
//       $arr3 = explode(',',$data['experience']);
//       $arr4 = explode(',',$data['language']);
//       $arr5 = explode(',',$data['preferred_location']);
//       $arr6 = explode(',',$data['type_of_wage']);
//       $arr7 = explode(',',$data['nativity']);
//         // Loop through each keyword and add condition
//         $this->db->where(['cat_id' =>$data['cat_id'],'sub_cat_id' =>$data['sub_cat_id'],'sub_sub_cat_id' =>$data['sub_sub_cat_id'],'mobile!=' => 0,'name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => ''/*,'preferred_city!=' => ''*/,'gender!=' => '','availability'=>1,'delete_status' => 1, 'status' => 1]);
//         if(!empty($data['gender'])){
//             $this->db->group_start();
//             foreach ($arr1 as $keyword) {
//                 $this->db->or_where("FIND_IN_SET('$keyword', gender) <> 0", NULL, FALSE);
//             }
//             $this->db->group_end();
//         }
//         if(!empty($data['location'])){
//             $this->db->group_start();
//             foreach ($arr2 as $lockeyword) {
//                 $this->db->or_where("FIND_IN_SET('$lockeyword', location) <> 0", NULL, FALSE);
//             }
//             $this->db->group_end();
//         }
//         if(!empty($data['experience'])){
//             $this->db->group_start();
//             foreach ($arr3 as $expkeyword) {
//                 $this->db->or_where("FIND_IN_SET('$expkeyword', exp) <> 0", NULL, FALSE);
//             }
//             $this->db->group_end();
//         }
//         if(!empty($data['language'])){
//             $this->db->group_start();
//             foreach ($arr4 as $lankeyword) {
//                 $this->db->or_where("FIND_IN_SET('$lankeyword', languages) <> 0", NULL, FALSE);
//             }
//             $this->db->group_end();
//         }
//         if(!empty($data['preferred_location'])){
//             $this->db->group_start();
//             foreach ($arr5 as $prefkeyword) {
//                 $this->db->or_where("FIND_IN_SET('$prefkeyword', preferred_city) <> 0", NULL, FALSE);
//             }
//             $this->db->group_end();
//         }
//         if(!empty($data['type_of_wage'])){
//             $this->db->group_start();
//             foreach ($arr6 as $wagekeyword) {
//                 $this->db->or_where("FIND_IN_SET('$wagekeyword', engagement) <> 0", NULL, FALSE);
//             }
//             $this->db->group_end();
//         }
//         if(!empty($data['nativity'])){
//             $this->db->group_start();
//             foreach ($arr7 as $natikeyword) {
//                 $this->db->or_where("FIND_IN_SET('$natikeyword', nativity) <> 0", NULL, FALSE);
//             }
//             $this->db->group_end();
//         }
//         $this->db->order_by('id','desc');
//         $query = $this->db->get('employees'); 
//         return $query->result_array();
// }

public function filter_search($data, $user_current_city_name, $lat = null, $lon = null) {
    // Step 1: Get the city ID based on the current city name
    $city_query = $this->db->select('id')
                           ->from('cities')
                           ->where('name', $user_current_city_name)
                           ->get();
    $city = $city_query->row(); 
    $city_id = $city ? $city->id : 0; 

    // Apply basic filters
    $this->db->where([
        'cat_id' => $data['cat_id'],
        'sub_cat_id' => $data['sub_cat_id'],
        'sub_sub_cat_id' => $data['sub_sub_cat_id'],
        'mobile !=' => 0,
        'name !=' => '',
        'profession !=' => '',
        'exp !=' => '',
        'engagement !=' => '',
        'languages !=' => '',
        'location !=' => '',
        'gender !=' => '',
        'availability' => 1,
        'delete_status' => 1,
        'status' => 1
    ]);
    
    // Apply dynamic filters (experience, gender, location, etc.)
    $filters = [
        'experience' => 'exp', 
        'gender' => 'gender', 
        'location' => 'location', 
      //  'language' => 'languages', 
        'preferred_location' => 'preferred_city', 
        'type_of_wage' => 'engagement', 
        'nativity' => 'nativity'
    ];
    
    foreach ($filters as $key => $column) {
        if (!empty($data[$key])) {
            $this->db->group_start();
            $values = explode(',', $data[$key]);
            foreach ($values as $value) {
                $this->db->or_where("FIND_IN_SET('" . trim($value) . "', $column) >", 0, FALSE);
            }
            $this->db->group_end();
        }
    }
    
    /* code chnages by sagar */
 $filters_l = [
       // 'experience' => 'exp', 
      //  'gender' => 'gender', 
      //  'location' => 'location', 
        'language' => 'languages', 
     //   'preferred_location' => 'preferred_city', 
      //  'type_of_wage' => 'engagement', 
       // 'nativity' => 'nativity'
    ];
    
    foreach ($filters_l as $key => $column) {
        if (!empty($data[$key])) {
            $this->db->group_start();
            $values = explode(',', $data[$key]);
            foreach ($values as $value) {
                $this->db->where("FIND_IN_SET('" . trim($value) . "', $column) >", 0, FALSE);
            }
            $this->db->group_end();
        }
    }

/* code changes by sagar */


    // Handle location filter conditions
    if (!empty($data['location_filter'])) {
        if ($data['location_filter'] === 'any city') {
            // Ignore emp_show_status and city restrictions
        } elseif ($data['location_filter'] === 'current city') {
            $this->db->where('current_city', $user_current_city_name);
        } elseif (is_numeric($data['location_filter'])) {
            // Apply distance filtering using Haversine formula
            $distance = (int) $data['location_filter'];
            $this->db->where("(6371 * acos(cos(radians($lat)) * cos(radians(lat)) * cos(radians(lon) - radians($lon)) + sin(radians($lat)) * sin(radians(lat)))) <=", $distance);
        }
    } else {
        // Default emp_show_status filtering when no location_filter is applied
        $this->db->group_start();
        $this->db->group_start();
        $this->db->where('emp_show_status', 1);
        $this->db->where('current_city', $user_current_city_name);
        $this->db->group_end();
        $this->db->or_group_start();
        $this->db->where('emp_show_status', 3);
        $this->db->where("FIND_IN_SET('$city_id', preferred_city) >", 0, FALSE);
        $this->db->group_end();
        $this->db->or_group_start();
        $this->db->where('emp_show_status', 2);
        $this->db->group_end();
        $this->db->group_end();
    }
    
    // Apply ordering
    $this->db->order_by('id', 'DESC');
    
    // Execute the query
    $query = $this->db->get('employees');
    return $query->result_array();
}


public function filter_search_home($data, $user_current_city_name, $lat = null, $lon = null) {
    // Get city ID based on the current city name
    $city_query = $this->db->select('id')
                           ->from('cities')
                           ->where('name', $user_current_city_name)
                           ->get();
    $city = $city_query->row(); 
    $city_id = $city ? $city->id : 0; 

    // Apply basic filters
    if (!empty($data['conditions'])) {
        $this->db->group_start();
        foreach ($data['conditions'] as $condition) {
            $this->db->or_group_start();
            $this->db->where('sub_cat_id', $condition['sub_cat_id']);
            $this->db->where('sub_sub_cat_id', $condition['sub_sub_cat_id']);
            $this->db->group_end();
        }
        $this->db->group_end();
    }
    
    $this->db->where([
        'cat_id!=' => 0,
        'mobile !=' => 0,
        'name !=' => '',
        'profession !=' => '',
        'exp !=' => '',
        'engagement !=' => '',
        'languages !=' => '',
        'location !=' => '',
        'gender !=' => '',
        'availability' => 1,
        'delete_status' => 1,
        'status' => 1
    ]);

    // Apply dynamic filters (experience, gender, location, etc.)
    $filters = [
        'experience' => 'exp', 
        'gender' => 'gender', 
        'location' => 'location', 
       // 'language' => 'languages', 
        'preferred_location' => 'preferred_city', 
        'type_of_wage' => 'engagement', 
        'nativity' => 'nativity'
    ];
    
    foreach ($filters as $key => $column) {
        if (!empty($data[$key])) {
            $this->db->group_start();
            $values = explode(',', $data[$key]);
            foreach ($values as $value) {
                $this->db->or_where("FIND_IN_SET('" . trim($value) . "', $column) >", 0, FALSE);
            }
            $this->db->group_end();
        }
    }


/* code chnages by sagar */
 $filters_l = [
       // 'experience' => 'exp', 
      //  'gender' => 'gender', 
      //  'location' => 'location', 
        'language' => 'languages', 
     //   'preferred_location' => 'preferred_city', 
      //  'type_of_wage' => 'engagement', 
       // 'nativity' => 'nativity'
    ];
    
    foreach ($filters_l as $key => $column) {
        if (!empty($data[$key])) {
            $this->db->group_start();
            $values = explode(',', $data[$key]);
            foreach ($values as $value) {
                $this->db->where("FIND_IN_SET('" . trim($value) . "', $column) >", 0, FALSE);
            }
            $this->db->group_end();
        }
    }

/* code changes by sagar */
    // Handle location filtering conditions
    if (!empty($data['location_filter'])) {
        if ($data['location_filter'] === 'any city') {
            // If "any city" is selected, do not filter by city or emp_show_status
        } elseif ($data['location_filter'] === 'current city') {
            // If "current city" is selected, filter by current_city
            $this->db->where('current_city', $user_current_city_name);
        } else {
            // If a distance is provided (e.g., "5 km"), apply the Haversine formula
            $kms = (int) $data['location_filter'];
            $this->db->where("(6371 * acos(cos(radians($lat)) * cos(radians(lat)) * cos(radians(lon) - radians($lon)) + sin(radians($lat)) * sin(radians(lat)))) <=", $kms);
        }
    } else {
        // If no location_filter is set, apply emp_show_status conditions
        $this->db->group_start();
        
        $this->db->group_start();
        $this->db->where('emp_show_status', 1);
        $this->db->where('current_city', $user_current_city_name);
        $this->db->group_end();

        $this->db->or_group_start();
        $this->db->where('emp_show_status', 3);
        $this->db->where("FIND_IN_SET('$city_id', preferred_city) >", 0, FALSE);
        $this->db->group_end();
        
        $this->db->or_group_start();
        $this->db->where('emp_show_status', 2);
        $this->db->group_end();
        
        $this->db->group_end();
    }
    
    // Apply ordering
    $this->db->order_by("FIELD(emp_show_status, 1, 3, 2)", NULL, FALSE);
    $this->db->order_by('id', 'DESC');
    
    // Execute query
    $query = $this->db->get('employees');
    return $query->result_array();
}

public function experience_filter($cat_id,$sub_cat_id,$filter_value,$to_value){
    $this->db->where(['cat_id' => $cat_id,'sub_cat_id' => $sub_cat_id ,'status' => 1, 'delete_status' => 1]);
	$this->db->where("exp BETWEEN '$filter_value' AND '$to_value'");
	$this->db->order_by('id','desc');
    $query = $this->db->get('employees');
    return $query->result_array();
}
public function get_employee_languages($emp_id) {
        /*$this->db->select('GROUP_CONCAT(languages.name ORDER BY languages.name ASC SEPARATOR ", ") as languages');
        $this->db->where('employees.id',$emp_id);
        $this->db->from('employees');
        //$this->db->join('employee_languages', 'employee_languages.employee_id = employees.id', 'left');
        $this->db->join('languages', 'where_in(languages.id = employees.languages)', 'left');
        //$this->db->group_by('employees.id');
        $query = $this->db->get();
        return $query->result();*/
        
        $query = $this->db->query("
            SELECT e.id, e.name, e.languages, 
                   GROUP_CONCAT(l.name ORDER BY l.name ASC SEPARATOR ', ') as languages
            FROM employees e
            LEFT JOIN languages l ON FIND_IN_SET(l.id, e.languages)
            WHERE e.id = $emp_id
            GROUP BY e.id, e.name, e.languages
        ", array($emp_id));

        return $query->row();
        
    }
    public function get_preffered_cities($emp_id) {
        /*$this->db->select('GROUP_CONCAT(languages.name ORDER BY languages.name ASC SEPARATOR ", ") as languages');
        $this->db->where('employees.id',$emp_id);
        $this->db->from('employees');
        //$this->db->join('employee_languages', 'employee_languages.employee_id = employees.id', 'left');
        $this->db->join('languages', 'where_in(languages.id = employees.languages)', 'left');
        //$this->db->group_by('employees.id');
        $query = $this->db->get();
        return $query->result();*/
        
        $query = $this->db->query("
            SELECT e.id, e.name, e.preferred_city, 
                   GROUP_CONCAT(c.name ORDER BY c.name ASC SEPARATOR ', ') as preferred_city_name
            FROM employees e
            LEFT JOIN cities c ON FIND_IN_SET(c.id, e.preferred_city)
            WHERE e.id = $emp_id
            GROUP BY e.id, e.name, e.preferred_city
        ", array($emp_id));

        return $query->row();
}
/*main data*/

/*employees*/
public function get_employees($cat_id,$sub_cat_id,$sub_sub_cat_id,$user_current_city_name) {
  
    // Get the city ID for the user's current city name
    $subquery = $this->db->select('id')
                         ->from('cities')
                         ->where('name', $user_current_city_name)
                         ->get_compiled_select();

    // Main query
    $this->db->select('employees.*,sub_sub_categories.name as sub_sub_cat_name,nativity.name as nativity_name');
    $this->db->from('employees');
    $this->db->where(['employees.cat_id' => $cat_id,'employees.sub_cat_id' => $sub_cat_id,'employees.sub_sub_cat_id' => $sub_sub_cat_id,'employees.mobile!=' => 0,'employees.name!=' => '','employees.profession!=' => '','employees.exp!=' => '','employees.engagement!=' => '','employees.languages!=' => '','employees.location!=' => '',/*'employees.preferred_city!=' => '',*/'employees.gender!=' => '','employees.availability'=>1,'employees.status' => 1, 'employees.delete_status' => 1]);
    $this->db->join('sub_sub_categories','sub_sub_categories.id=employees.sub_sub_cat_id','left');
    $this->db->join('nativity','nativity.id=employees.nativity','left');
    $this->db->group_start();
    // Group conditions
    $this->db->group_start();
        // Employees who selected current_city
        $this->db->where('employees.emp_show_status', 1);
        $this->db->where('employees.current_city', $user_current_city_name);
    $this->db->group_end();

    $this->db->or_group_start();
        // Employees who selected preferred_city and include the user's city ID
        $this->db->where('employees.emp_show_status', 3);
        $this->db->where("FIND_IN_SET(($subquery), employees.preferred_city) >", 0, false); // Match city ID in preferred_city
    $this->db->group_end();

    $this->db->or_group_start();
        // Employees who selected any_city
        $this->db->where('employees.emp_show_status', 2);
    $this->db->group_end();

    // Ordering by emp_show_status priority
    $this->db->order_by("FIELD(employees.emp_show_status, 1, 3, 2)", null, false);
    
    $this->db->group_end();

    // Execute query
    $query = $this->db->get();

    // Return results
    return $query->result_array();
}

/*public function get_employees_search($sub_cat_id,$user_current_city_name) {
  
    // Get the city ID for the user's current city name
    $subquery = $this->db->select('id')
                         ->from('cities')
                         ->where('name', $user_current_city_name)
                         ->get_compiled_select();

    // Main query
    $this->db->select('employees.*');
    $this->db->from('employees');
    $this->db->where(['sub_cat_id' => $sub_cat_id,'cat_id!=' => 0,'mobile!=' => 0,'name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '',/*'preferred_city!=' => '','gender!=' => '','availability'=>1,'status' => 1, 'delete_status' => 1]);

    $this->db->group_start();
    // Group conditions
    $this->db->group_start();
        // Employees who selected current_city
        $this->db->where('emp_show_status', 1);
        $this->db->where('current_city', $user_current_city_name);
    $this->db->group_end();

    $this->db->or_group_start();
        // Employees who selected preferred_city and include the user's city ID
        $this->db->where('emp_show_status', 3);
        $this->db->where("FIND_IN_SET(($subquery), preferred_city) >", 0, false); // Match city ID in preferred_city
    $this->db->group_end();

    $this->db->or_group_start();
        // Employees who selected any_city
        $this->db->where('emp_show_status', 2);
    $this->db->group_end();

    // Ordering by emp_show_status priority
    $this->db->order_by("FIELD(emp_show_status, 1, 3, 2)", null, false);
    
    $this->db->group_end();

    // Execute query
    $query = $this->db->get();

    // Return results
    return $query->result_array();
}*/

public function get_employees_search($search, $user_current_city_name) {
    // Get IDs from sub_categories and sub_sub_categories that match the given search term
    $sub_cat_ids = $this->db->select('id')
                            ->from('sub_categories')
                            ->like('name', $search) // Use LIKE to allow partial matches
                            ->get()
                            ->result_array();
                            
    $sub_sub_cat_ids = $this->db->select('id')
                                ->from('sub_sub_categories')
                                ->like('name', $search) // Use LIKE for better search flexibility
                                ->get()
                                ->result_array();

    // Extract IDs as arrays
    $sub_cat_ids = array_column($sub_cat_ids, 'id');
    $sub_sub_cat_ids = array_column($sub_sub_cat_ids, 'id');

    // **If no matching sub-category or sub-sub-category is found, return an empty array**
    if (empty($sub_cat_ids) && empty($sub_sub_cat_ids)) {
        return [];
    }

    // Get the city ID for the user's current city name
    $subquery = $this->db->select('id')
                         ->from('cities')
                         ->where('name', $user_current_city_name)
                         ->limit(1) // Ensure only one result
                         ->get_compiled_select();

    // Main query
    $this->db->select('employees.*');
    $this->db->from('employees');

    // Filter employees who match sub_cat_id or sub_sub_cat_id
    $this->db->group_start();
    if (!empty($sub_cat_ids)) {
        $this->db->where_in('sub_cat_id', $sub_cat_ids);
    }
    if (!empty($sub_sub_cat_ids)) {
        $this->db->or_where_in('sub_sub_cat_id', $sub_sub_cat_ids);
    }
    $this->db->group_end();

    // Additional employee filters
    $this->db->where('cat_id !=', 0);
    $this->db->where('mobile !=', 0);
    $this->db->where('name !=', '');
    $this->db->where('profession !=', '');
    $this->db->where('exp !=', '');
    $this->db->where('engagement !=', '');
    $this->db->where('languages !=', '');
    $this->db->where('location !=', '');
    /*$this->db->where('preferred_city !=', '');*/ // Uncomment if needed
    $this->db->where('gender !=', '');
    $this->db->where('availability', 1);
    $this->db->where('status', 1);
    $this->db->where('delete_status', 1);

    // Employees location filtering
    $this->db->group_start();

    // Employees who selected current_city
    $this->db->group_start();
        $this->db->where('emp_show_status', 1);
        $this->db->where('current_city', $user_current_city_name);
    $this->db->group_end();

    // Employees who selected preferred_city
    $this->db->or_group_start();
        $this->db->where('emp_show_status', 3);
        $this->db->where("FIND_IN_SET(($subquery), preferred_city) > 0", NULL, FALSE); // Match city ID in preferred_city
    $this->db->group_end();

    // Employees who selected any_city
    $this->db->or_group_start();
        $this->db->where('emp_show_status', 2);
    $this->db->group_end();

    $this->db->group_end(); // Closing group for city filters

    // Ordering by emp_show_status priority
    $this->db->order_by("FIELD(emp_show_status, 1, 3, 2)", null, false);

    // Log query before execution (useful for debugging)
    $query = $this->db->get();
    error_log("Executed SQL Query: " . $this->db->last_query());

    // Fetch results
    $result = $query->result_array();

    return $result;
}

/*employees*/


/*employee profile*/
public function get_employee_languages_tel($emp_id) {
    $query = $this->db->query("
        SELECT e.id, e.name, e.languages, 
               GROUP_CONCAT(l.name_tl ORDER BY l.name ASC SEPARATOR ', ') as languages
        FROM employees e
        LEFT JOIN languages l ON FIND_IN_SET(l.id, e.languages)
        WHERE e.id = $emp_id
        GROUP BY e.id, e.name, e.languages
    ", array($emp_id));

    return $query->row();
        
}
public function get_employee_languages_hin($emp_id) {
    $query = $this->db->query("
        SELECT e.id, e.name, e.languages, 
               GROUP_CONCAT(l.name_hi ORDER BY l.name ASC SEPARATOR ', ') as languages
        FROM employees e
        LEFT JOIN languages l ON FIND_IN_SET(l.id, e.languages)
        WHERE e.id = $emp_id
        GROUP BY e.id, e.name, e.languages
    ", array($emp_id));

    return $query->row();
        
}
public function get_employee_languages_eng($emp_id) {
    /*$query = $this->db->query("
        SELECT e.id, e.name, e.languages, 
               GROUP_CONCAT(l.name ORDER BY l.name ASC SEPARATOR ', ') as languages
        FROM employees e
        LEFT JOIN languages l ON FIND_IN_SET(l.id, e.languages)
        WHERE e.id = $emp_id
        GROUP BY e.id, e.name, e.languages
    ", array($emp_id));

    return $query->row();*/
    
    $query = $this->db->query("
            SELECT e.id, e.name, e.languages, 
               GROUP_CONCAT(l.name ORDER BY l.name ASC SEPARATOR ', ') as languages
        FROM employees e
        LEFT JOIN languages l ON FIND_IN_SET(l.id, e.languages)
        WHERE e.id = $emp_id
        GROUP BY e.id, e.name, e.languages
    ", array($emp_id));

    return $query->row();
    
        
}
public function get_preffered_cities_tel($emp_id) {
        
    $query = $this->db->query("
        SELECT e.id, e.name, e.preferred_city, 
               GROUP_CONCAT(c.name_tl ORDER BY c.name ASC SEPARATOR ', ') as preferred_city
        FROM employees e
        LEFT JOIN cities c ON FIND_IN_SET(c.id, e.preferred_city)
        WHERE e.id = $emp_id
        GROUP BY e.id, e.name, e.preferred_city
    ", array($emp_id));

    return $query->row();
}
public function get_preffered_cities_hin($emp_id) {
        
    $query = $this->db->query("
        SELECT e.id, e.name, e.preferred_city, 
               GROUP_CONCAT(c.name_hi ORDER BY c.name ASC SEPARATOR ', ') as preferred_city
        FROM employees e
        LEFT JOIN cities c ON FIND_IN_SET(c.id, e.preferred_city)
        WHERE e.id = $emp_id
        GROUP BY e.id, e.name, e.preferred_city
    ", array($emp_id));

    return $query->row();
}
public function get_preffered_cities_eng($emp_id) {
        
    $query = $this->db->query("
        SELECT e.id, e.name, e.preferred_city, 
               GROUP_CONCAT(c.name ORDER BY c.name ASC SEPARATOR ', ') as preferred_city
        FROM employees e
        LEFT JOIN cities c ON FIND_IN_SET(c.id, e.preferred_city)
        WHERE e.id = $emp_id
        GROUP BY e.id, e.name, e.preferred_city
    ", array($emp_id));

    return $query->row();
}
/*employee profile*/

/*employee reviews*/
public function get_avg($emp_id){
    $this->db->select('count(rr.user_id) as count,sum(rr.rating) as rating')->from('ratings_reviews rr');
    $this->db->where('rr.emp_id',$emp_id);
    $this->db->order_by('rr.id','desc');
    $query = $this->db->get();
    return $query->result_array();
}
public function ratings_reviews($emp_id){
    $this->db->select('rr.*,u.name as username')->from('ratings_reviews rr');
    $this->db->where('rr.emp_id',$emp_id);
    $this->db->join('users u','u.id=rr.user_id','left');
    $this->db->order_by('rr.id','desc');
    $query = $this->db->get();
    return $query->result_array();
}
/*employee reviews*/

/*employee calls*/
public function get_call_history($emp_id){
    $this->db->select('ch.user_id, ch.id, ch.emp_id, u.name AS user_name,u.mobile as user_mobile, ch.connect_time, ch.call_type,ch.user_call_status,ch.emp_call_status');
    $this->db->from('call_history AS ch');
    $this->db->join('users AS u', 'u.id = ch.user_id', 'left');
    $this->db->join('(SELECT user_id, MAX(id) AS max_id FROM call_history WHERE emp_id = '.$emp_id.' GROUP BY user_id) AS latest_calls', 'ch.user_id = latest_calls.user_id AND ch.id = latest_calls.max_id', 'inner');
    $this->db->order_by('ch.id', 'DESC');
    $query = $this->db->get();
    
    $result = $query->result_array(); // Fetch results as an array of objects 
    
    return $result;
}
public function get_user_call_history($user_id){
    $this->db->select('ch.user_id, ch.id, ch.emp_id, e.name AS emp_name, e.mobile AS emp_mobile, ch.connect_time, ch.call_type,ch.user_call_status,ch.emp_call_status,sc.name as sub_cat_name');
    $this->db->from('call_history AS ch');
    $this->db->join('employees AS e', 'e.id = ch.emp_id', 'left');
    $this->db->join('sub_categories AS sc', 'sc.id = e.sub_cat_id', 'left');
    $this->db->join('(SELECT emp_id, MAX(id) AS max_id FROM call_history WHERE user_id = '.$user_id.' GROUP BY emp_id) AS latest_calls', 'ch.emp_id = latest_calls.emp_id AND ch.id = latest_calls.max_id', 'inner');
    $this->db->order_by('ch.id', 'DESC');
    $query = $this->db->get();
    
    $result = $query->result_array(); // Fetch results as an array of objects 
    
    return $result;
}
/*employee calls*/

public function get_unread_count($user_id) {
    $this->db->select('COUNT(*) as unread_count');
    $this->db->from('notifications');
    $this->db->where("(member_id = 'all' OR member_id = $user_id)");
    $this->db->where("id NOT IN (SELECT notification_id FROM notification_reads WHERE user_id = $user_id AND read_status = 1)", NULL, FALSE);
    $query = $this->db->get();
    return $query->row()->unread_count;
}
public function get_unread_notifications($user_id){
    $this->db->where('member_id',$user_id);
    $this->db->or_where('member_id','all');
    $this->db->order_by('id','desc');
    $query = $this->db->get('notifications');
    return $query->result_array();
}
public function mark_as_read($notification_id, $user_id) {
    // Get all unread notifications for this user
    $this->db->select('id');
    $this->db->from('notifications');
    $this->db->where("(member_id = 'all' OR member_id = $user_id)");
    $this->db->where("id NOT IN (SELECT notification_id FROM notification_reads WHERE user_id = $user_id AND read_status = 1)", NULL, FALSE);
    $query = $this->db->get();
    
    $notifications = $query->result_array(); // Get all unread notifications

    if (!empty($notifications)) {
        $data = [];
        $timestamp = date('Y-m-d H:i:s');

        foreach ($notifications as $notification) {
            $data[] = [
                'notification_id' => $notification['id'],
                'user_id' => $user_id,
                'read_status' => 1,
                'read_on' => $timestamp
            ];
        }

        if (!empty($data)) {
            // Insert all at once (batch insert)
            $this->db->insert_batch('notification_reads', $data);
        }
    }
}

/*user_job_portal*/
public function get_jobs($user_id) {
    $this->db->select('
        job_postings.*,
        users.business_name,
        users.image,
        services.name as cat_name,
        sub_categories.name as sub_cat_name,
        IFNULL(sub_sub_categories.name, "") as sub_sub_cat_name,
        nativity.name as nativity_name,
        COUNT(job_applicants.id) as applicant_count,
        (
            SELECT GROUP_CONCAT(name SEPARATOR ", ")
            FROM languages
            WHERE FIND_IN_SET(id, job_postings.languages)
        ) as languages,
        (
            SELECT GROUP_CONCAT(name SEPARATOR ", ")
            FROM cities
            WHERE FIND_IN_SET(id, job_postings.preferred_city)
        ) as preferred_city
    ');
    $this->db->from('job_postings');
    $this->db->where('job_postings.user_id', $user_id);

    // Show jobs where today <= created_on + 1 month
    $this->db->where('DATE_ADD(job_postings.created_on, INTERVAL 1 MONTH) >=', date('Y-m-d H:i:s'));

    $this->db->join('users', 'users.id = job_postings.user_id', 'left');
    $this->db->join('services', 'services.id = job_postings.cat_id', 'left');
    $this->db->join('sub_categories', 'sub_categories.id = job_postings.sub_cat_id', 'left');
    $this->db->join('sub_sub_categories', 'sub_sub_categories.id = job_postings.sub_sub_cat_id', 'left');
    $this->db->join('job_applicants', 'job_applicants.job_id = job_postings.id', 'left');
    $this->db->join('nativity', 'nativity.id = job_postings.nativity', 'left');

    $this->db->group_by('job_postings.id');
    $this->db->order_by('job_postings.id','desc');
    $query = $this->db->get();
    return $query->result_array();
}
public function get_job_applicants($job_id){
    $this->db->select('
        job_applicants.*,
        employees.name,
        employees.mobile,
        employees.current_area,
        sub_categories.name as profession,
        (
            SELECT GROUP_CONCAT(name SEPARATOR ", ")
            FROM languages
            WHERE FIND_IN_SET(id, job_applicants.languages)
        ) as languages,
        IFNULL(sub_sub_categories.name, "") as sub_sub_cat_name,
        nativity.name as nativity_name,
        job_postings.gender,
        job_postings.current_city,
        IFNULL((
            SELECT ROUND(AVG(rating))
            FROM ratings_reviews
            WHERE ratings_reviews.emp_id = job_applicants.emp_id
        ), 0) as ratings
    ');
    $this->db->from('job_applicants');
    $this->db->where('job_applicants.job_id', $job_id);
    $this->db->join('employees', 'employees.id = job_applicants.emp_id', 'left');
    $this->db->join('sub_categories', 'sub_categories.id = job_applicants.sub_cat_id');
    $this->db->join('sub_sub_categories', 'sub_sub_categories.id = job_applicants.sub_sub_cat_id', 'left');
    $this->db->join('job_postings', 'job_postings.id = job_applicants.job_id', 'left');
    $this->db->join('nativity', 'nativity.id = employees.nativity','left');
    $this->db->order_by('job_applicants.id', 'desc');
    
    $query = $this->db->get();
    return $query->result_array();
}

public function get_expired_jobs($user_id) {
    $this->db->select('
        job_postings.*,
        users.business_name,
        users.image,
        services.name as cat_name,
        sub_categories.name as sub_cat_name,
        IFNULL(sub_sub_categories.name, "") as sub_sub_cat_name,
        nativity.name as nativity_name,
        COUNT(job_applicants.id) as applicant_count,
        (
            SELECT GROUP_CONCAT(name SEPARATOR ", ")
            FROM languages
            WHERE FIND_IN_SET(id, job_postings.languages)
        ) as languages,
        (
            SELECT GROUP_CONCAT(name SEPARATOR ", ")
            FROM cities
            WHERE FIND_IN_SET(id, job_postings.preferred_city)
        ) as preferred_city
    ');
    $this->db->from('job_postings');
    $this->db->where('job_postings.user_id', $user_id);

    // Get jobs created more than 1 month ago
    $this->db->where('DATE_ADD(job_postings.created_on, INTERVAL 1 MONTH) <', date('Y-m-d H:i:s'));

    $this->db->join('users', 'users.id = job_postings.user_id', 'left');
    $this->db->join('services', 'services.id = job_postings.cat_id', 'left');
    $this->db->join('sub_categories', 'sub_categories.id = job_postings.sub_cat_id', 'left');
    $this->db->join('sub_sub_categories', 'sub_sub_categories.id = job_postings.sub_sub_cat_id', 'left');
    $this->db->join('job_applicants', 'job_applicants.job_id = job_postings.id', 'left');
    //$this->db->join('job_postings', 'job_postings.id = job_applicants.job_id', 'left');
    $this->db->join('nativity','nativity.id=job_postings.nativity','left');
    $this->db->group_by('job_postings.id');
    $this->db->order_by('job_postings.id','desc');

    $query = $this->db->get();
    return $query->result_array();
}
public function all_job_matched($job_id) {
    $data = [];

    // Fetch job
    $job = $this->db->get_where('job_postings', ['id' => $job_id])->row_array();
    if (!$job) return $data;

    $job_languages = !empty($job['languages']) ? explode(',', $job['languages']) : [];
    $job_pref_city_ids = !empty($job['preferred_city']) ? explode(',', $job['preferred_city']) : [];

    $this->db->select('employees.id, employees.player_id');
    $this->db->from('employees');
    $this->db->join('job_applicants', 'job_applicants.emp_id = employees.id AND job_applicants.job_id = '.$job_id, 'left');

    // Basic filters
    $this->db->where([
        'employees.cat_id'         => $job['cat_id'],
        'employees.sub_cat_id'     => $job['sub_cat_id'],
        'employees.sub_sub_cat_id' => $job['sub_sub_cat_id'],
        'employees.exp'            => $job['exp'],
        'employees.engagement'     => $job['engagement'],
        'employees.gender'         => $job['gender'],
        'employees.availability'   => 1,
        'employees.status'         => 1,
        'employees.delete_status'  => 1
    ]);

    // Required profile completeness
    $this->db->where("employees.name !=", "");
    $this->db->where("employees.profession !=", "");
    $this->db->where("employees.mobile !=", "");
    $this->db->where("employees.location !=", "");
    $this->db->where("employees.languages !=", "");
    $this->db->where("employees.exp !=", "");
/* code changes by sagar */
 $nativity = $job['nativity'];
 if($nativity > 0){
     $this->db->where("employees.nativity", $nativity);
 }
/* code changes by sagar */
    // Match language
    if (!empty($job_languages)) {
        $this->db->group_start();
        foreach ($job_languages as $lang) {
            $this->db->or_where("FIND_IN_SET(" . (int)$lang . ", employees.languages) >", 0, false);
        }
        $this->db->group_end();
    }

    // Match visibility
    $this->db->group_start();

        // emp_show_status = 1 and same city
        $this->db->group_start();
            $this->db->where('employees.current_city', $job['current_city']);
            $this->db->where('employees.emp_show_status', 1);
        $this->db->group_end();

        // emp_show_status = 2 (visible to all)
        $this->db->or_where('employees.emp_show_status', 2);

        // emp_show_status = 3 (preferred city match)
        // if (!empty($job_pref_city_ids)) {
        //     $this->db->or_group_start();
        //         $this->db->where('employees.emp_show_status', 3);
        //         $this->db->group_start();
        //             foreach ($job_pref_city_ids as $city_id) {
        //                 $this->db->or_where("FIND_IN_SET(" . (int)$city_id . ", employees.preferred_city) >", 0, false);
        //             }
        //         $this->db->group_end();
        //     $this->db->group_end();
        // }
        /* distance checking */
        $this->db->or_group_start();
         $kms = (int) $job['distance'];
         $lat  = $job['lat'];
         $lon = $job['lon'];
         //$this->db->where('employees.emp_show_status', 3);
         $this->db->where("(6371 * acos(cos(radians($lat)) * cos(radians(lat)) * cos(radians(lon) - radians($lon)) + sin(radians($lat)) * sin(radians(lat)))) <=", $kms);
    $this->db->group_end();

    $this->db->group_end(); // end of visibility

    $query = $this->db->get();
//echo $this->db->last_query();exit;
    foreach ($query->result() as $row) {
        $data[] = [
            'id'        => $row->id,
            'player_id' => $row->player_id
        ];
    }

    return $data;
}
public function sendNotification_job_post($playerId, $title, $message, $userType = null) {
    $appId = '9f0a6d2f-3a84-491e-a11b-a178fa7747dc'; // Your OneSignal App ID
    $apiKey = 'os_v2_app_t4fg2lz2qrer5ii3uf4pu52h3sqfjwdq5sxucsmg42gjqpxbqp6lz42sug2po2pxjlma4fhvzo2rp3t27idijrlb2pfuvzr5t4n4lua'; // Your REST API Key

    $notificationData = [
        "app_id" => $appId,
        "headings" => ["en" => $title],
        "contents" => ["en" => $message],
        "small_icon" => "kaam_hai_na_logo",
        "badge" => 3,
    ];

    if ($playerId === 'all') {
        $notificationData["filters"] = [
            ["field" => "tag", "key" => "user_type", "relation" => "=", "value" => $userType]
        ];
    } elseif (is_array($playerId)) {
        $notificationData["include_player_ids"] = $playerId;
    } else {
        $notificationData["include_player_ids"] = [$playerId];
    }

    $ch = curl_init("https://onesignal.com/api/v1/notifications");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            "Authorization: Basic $apiKey",
            "Content-Type: application/json"
        ],
        CURLOPT_POSTFIELDS => json_encode($notificationData),
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_SSL_VERIFYPEER => false
    ]);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        log_message('error', 'OneSignal cURL error: ' . curl_error($ch));
        curl_close($ch);
        return false;
    }

    curl_close($ch);
    return json_decode($response, true);
}

/*user_job_portal*/

/*employee_job_portal*/
public function get_employee_job_list($employee) {
    $emp = $employee[0];
    $lat = $emp['lat'];
    $lon = $emp['lon'];

    $this->db->select('
        job_postings.*,
        sub_categories.name as profession_en,
        sub_categories.name_tl as profession_te,
        sub_categories.name_hi as profession_hi,
        users.business_name,
        users.image,
        IFNULL(job_applicants.applied_status, "not_applied") as applied_status,
        IFNULL(
            (SELECT GROUP_CONCAT(name SEPARATOR ", ")
             FROM cities
             WHERE FIND_IN_SET(id, job_postings.preferred_city)
            ), 
            ""
        ) AS preferred_city,
        (6371 * acos(
            cos(radians(job_postings.lat)) * cos(radians(employees.lat)) * 
            cos(radians(employees.lon) - radians(job_postings.lon)) + 
            sin(radians(job_postings.lat)) * sin(radians(employees.lat))
        )) AS distance_km
    ')
    ->from('job_postings')
    ->join('employees', "employees.id = {$emp['id']}", 'left')
    ->join('sub_categories', 'sub_categories.id = job_postings.sub_cat_id', 'left')
    ->join('users', 'users.id = job_postings.user_id', 'left')
    ->join('job_applicants', "job_applicants.job_id = job_postings.id AND job_applicants.emp_id = {$emp['id']}", 'left')
    ->where([
        'job_postings.cat_id'         => $emp['cat_id'],
        'job_postings.sub_cat_id'     => $emp['sub_cat_id'],
        'job_postings.sub_sub_cat_id' => $emp['sub_sub_cat_id'],
        'job_postings.exp'            => $emp['exp'],
        'job_postings.engagement'     => $emp['engagement'],
        'job_postings.gender'         => $emp['gender'],
    ]);
    
   //  $this->db->where('job_postings.nativity', $emp['nativity']);
   
    // code changes by sagar
     //for nativity matching
     $this->db->group_start();
     $this->db->where('job_postings.nativity', 0);
    $this->db->or_where('job_postings.nativity', $emp['nativity']);
     $this->db->group_end();
    // code changes by sagar




   $this->db->where('job_postings.job_status',1);
    // Language matching
    if (!empty($emp['languages'])) {
        $langs = explode(',', $emp['languages']);
        $this->db->group_start();
        foreach ($langs as $lang_id) {
            $this->db->or_where("FIND_IN_SET($lang_id, job_postings.languages) >", 0, false);
        }
        $this->db->group_end();
    }
   
    // Start visibility conditions group
    $this->db->group_start();

    // 1. job_show_status = 1 and city matches
    $this->db->group_start()
        ->where('job_postings.job_show_status', 1)
        ->where('job_postings.current_city', $emp['current_city'])
    ->group_end();

    // 2. job_show_status = 3 and within distance
    $this->db->or_group_start()
        ->where('job_postings.job_show_status', 3)
        ->where('job_postings.distance IS NOT NULL', null, false)
        ->where("(6371 * acos(
            cos(radians($lat)) * cos(radians(job_postings.lat)) * 
            cos(radians(job_postings.lon) - radians($lon)) + 
            sin(radians($lat)) * sin(radians(job_postings.lat))
        )) <= job_postings.distance", null, false)
    ->group_end();

    // 3. job_show_status = 2 (visible to all)
    $this->db->or_group_start()
        ->where('job_postings.job_show_status', 2)
    ->group_end();

    // End visibility condition group
    $this->db->group_end();
// Get jobs created more than 1 month ago
   // $this->db->where('DATE_ADD(job_postings.created_on, INTERVAL 1 MONTH) <', date('Y-m-d H:i:s'));
    $this->db->order_by('job_postings.id', 'DESC');

    return $this->db->get()->result_array();
}

public function get_applied_jobs($emp_id, $lang) {
    $this->db->select('
        job_applicants.*,job_postings.distance,
        users.business_name,
        users.image,
        job_postings.current_area,
        job_postings.current_city,
        job_postings.engagement,
        job_postings.job_show_status,
        sub_categories.name as profession_en,
        sub_categories.name_hi as profession_hi,
        sub_categories.name_tl as profession_te,
        IFNULL(
            (SELECT GROUP_CONCAT(name SEPARATOR ", ")
             FROM cities
             WHERE FIND_IN_SET(id, job_postings.preferred_city)
            ), 
            ""
        ) AS preferred_city
    ')
    ->from('job_applicants')
    ->join('job_postings', 'job_postings.id = job_applicants.job_id', 'left')
    ->join('users', 'users.id = job_postings.user_id', 'left')
    ->join('sub_categories', 'sub_categories.id = job_applicants.sub_cat_id', 'left')
    ->where('job_applicants.emp_id', $emp_id)
   // ->where('job_postings.job_status', 1)
    ->order_by('job_applicants.id', 'desc');

    $results = $this->db->get()->result_array();

    foreach ($results as &$row) {
        // Profession translation
        if ($lang == 'hi') {
            $row['profession'] = $row['profession_hi'];
        } elseif ($lang == 'te') {
            $row['profession'] = $row['profession_te'];
        } else {
            $row['profession'] = $row['profession_en'];
        }

        // Engagement translation
        if ($lang == 'hi') {
            if ($row['engagement'] == 'daily_wages') {
                $row['engagement'] = 'ैनिक मज़दूरी';
            } elseif ($row['engagement'] == 'salary') {
                $row['engagement'] = 'वेतन';
            } elseif ($row['engagement'] == 'contract') {
                $row['engagement'] = 'अनुबंध';
            }
        } elseif ($lang == 'te') {
            if ($row['engagement'] == 'daily_wages') {
                $row['engagement'] = 'రోజువారీ_వేతనాలు';
            } elseif ($row['engagement'] == 'salary') {
                $row['engagement'] = 'జీతం';
            } elseif ($row['engagement'] == 'contract') {
                $row['engagement'] = 'ఒప్పందం';
            }
        }
    }

    return $results;
}
/*employee_job_portal*/


}
?>